@echo off

rem Check if running as administrator
net session >nul 2>&1
if %errorlevel% NEQ 0 (
    echo Administrator rights required. Please run the script as an administrator.
    pause
    exit /b 1
)

rem Set folder reference
set "TEAMVIEWER_FOLDER=%~dp0TeamViewer Files"

rem Check if the TeamViewer folder exists
if not exist "%TEAMVIEWER_FOLDER%" (
    echo The TeamViewer folder "%TEAMVIEWER_FOLDER%" does not exist. Please check the path.
    pause
    exit /b 1
)

set "REG_FILE=%TEAMVIEWER_FOLDER%\TeamViewer_Settings.reg"

rem Check if the TeamViewer MSI file exists
if defined ProgramFiles(x86) (
    set "MSI_FILE=%TEAMVIEWER_FOLDER%\TeamViewer_Host-x64.msi"
) else (
    set "MSI_FILE=%TEAMVIEWER_FOLDER%\TeamViewer_Host-x86.msi"
)

if not exist "%MSI_FILE%" (
    echo The MSI file "%MSI_FILE%" was not found. Please check the path.
    pause
    exit /b 1
)

rem Check if TeamViewer is already installed
reg query "HKLM\SOFTWARE\TeamViewer" >nul 2>&1

if %errorlevel% NEQ 0 (
    goto Install
)

rem Get the current TeamViewer version
for /f "tokens=3*" %%a in ('reg query "HKLM\SOFTWARE\TeamViewer" /v Version 2^>nul') do set "CURRENT_VERSION=%%b"

if "%CURRENT_VERSION%"=="" (
    goto Install
)

rem Extract major version from the current version
for /f "tokens=1 delims=." %%c in ("%CURRENT_VERSION%") do set "CURRENT_MAJOR_VERSION=%%c"

if "%CURRENT_MAJOR_VERSION%"=="" (
    goto Install
)

rem Extract major version from the installed version (ensure TEAMVIEWER_VERSION is defined elsewhere)
for /f "tokens=1 delims=." %%d in ("%TEAMVIEWER_VERSION%") do set "INSTALLED_MAJOR_VERSION=%%d"

if "%INSTALLED_MAJOR_VERSION%"=="" (
    goto Install
)

rem Check if the installed version is greater or equal to the current version
if "%INSTALLED_MAJOR_VERSION%" geq "%CURRENT_MAJOR_VERSION%" (
    echo TeamViewer %CURRENT_VERSION% is already installed.
    goto AskUser
)

rem Check if versions differ, prompting the user to uninstall
if "%INSTALLED_MAJOR_VERSION%" neq "%CURRENT_MAJOR_VERSION%" (
    echo Please uninstall TeamViewer %CURRENT_VERSION% before installing this version. Cannot update the current version.
    pause
    exit /b 1
)

:Install
echo Installing TeamViewer... Please wait! 

rem Importing registry file...
regedit /s "%REG_FILE%"

start /wait MSIEXEC.EXE /i "%MSI_FILE%" /qn ASSIGNMENTOPTIONS="–alias %COMPUTERNAME% --grant-easy-access --reassign" CUSTOMCONFIGID="64m83mj" APITOKEN="23370927-NF1wbazdxV5oyL36BVvd"

echo TeamViewer Installed. Applying TeamViewer Settings...
timeout /t 10 /nobreak > nul 2>&1

rem Install TeamViewer and configure UI
"%ProgramFiles%\TeamViewer\TeamViewer.exe" assignment --id 0001CoABChBOhG0g6vYR7qrqZnJ_ASPrEigIACAAAgAJABBlCawdNzcI8NlWi072Y5XDZ8_PCqWRs6FV7NAazwxUGkADBn9P4HcNaREs20CMHASg-_d4ktj_TAHNjr3f4glyOFYqjjKskIGA7_IezMkP1nTKmQ-TP2_Ph6BkBF5AMIy1IAEQkZKN5gU= --retries 5 --timeout=120

timeout /t 2 /nobreak > nul 2>&1

"%ProgramFiles%\TeamViewer\TeamViewer.exe" assign --api-token 24696914-2jggyl5FDlOO5hg240MA --alias %COMPUTERNAME% --grant-easy-access

timeout /t 2 /nobreak > nul 2>&1

rem Start TeamViewer
start "" "C:\Program Files\TeamViewer\TeamViewer.exe"

if %errorlevel% neq 0 (
    echo.
    echo Failed to start TeamViewer. Please check the installation.
    pause
    exit /b 1
)

echo.
echo TeamViewer installed!
echo.
pause
exit /b 0

:AskUser
set /p CONTINUE="Would you like to continue the installation anyway? (y/n): "

if /i "%CONTINUE%"=="y" (
    echo Continuing with the installation...
    goto Install
) else if /i "%CONTINUE%"=="n" (
    echo Installation aborted. Closing installer...
    exit /b 0
) else (
    echo Invalid input. Please type 'y' for Yes or 'n' for No.
    goto AskUser
)